/* eslint-disable max-len */
define([
    'underscore',
    'backbone',
    'App',
    'Layout',
    'modules/community-care-request/new-appointment-request-question/service-distance-selection/community-care-service-distance-layout-view',
    'modules/community-care-request/new-appointment-request-question/service-distance-selection/service-section-view',
    'modules/community-care-request/new-appointment-request-question/service-distance-selection/distance-section-view',
    'modules/new-appointment-wizard/wizard-step-model',
    'modules/community-care-request/new-appointment-request-question/service-distance-selection/community-care-distance-eligibility-input-section-view',
],
function (
    _,
    Backbone,
    app,
    Layout,
    CommunityCareNewAppointmentLayoutView,
    ServiceSectionView,
    DistanceSectionView,
    WizardStepModel,
    CCDistanceEligibilityInputSection
) {
    'use strict';

    describe('Community Care New Appointment Layout View', function () {
        var view;
        var $view;
        var layout = new Layout();
        var model = new Backbone.Model({
            travel: 'no',
            unusual: 'no',
            steps: [1, 2, 3],
        });
        var locations = ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20', '21', '22', '23', '24', '25', '26', '27', '28', '29'];
        var splitLocations = [
            ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20', '21', '22', '23', '24', '25'],
            ['26', '27', '28', '29'],
        ];
        layout.render();

        beforeEach(function () {
            spyOn(CommunityCareNewAppointmentLayoutView.prototype, 'disableContinueButton');
            spyOn(CommunityCareNewAppointmentLayoutView.prototype, 'enableContinueButton');
            spyOn(CommunityCareNewAppointmentLayoutView.prototype, 'uncheckBothTravelRadios');
            spyOn(CommunityCareNewAppointmentLayoutView.prototype, 'showCCDistanceEligibilityInputSection');
            spyOn(CommunityCareNewAppointmentLayoutView.prototype, 'hideCCDistanceEligibilityInputSection');
            spyOn(CommunityCareNewAppointmentLayoutView.prototype, 'showCCDistanceEligibleMessage');
            spyOn(CommunityCareNewAppointmentLayoutView.prototype, 'findClosestFacility');
            spyOn(CommunityCareNewAppointmentLayoutView.prototype, 'openExternalLink');
            spyOn(CommunityCareNewAppointmentLayoutView.prototype, 'googlePromiseChecker').and.callFake(_.noop);
            spyOn(CommunityCareNewAppointmentLayoutView.prototype, 'getPatientLocations').and.returnValue(locations);
            spyOn(DistanceSectionView.prototype, 'initialize').and.callFake(_.noop);
            spyOn(app, 'isCcEligFeatureEnabled').and.callFake(function() {
                return true;
            });
            spyOn(CCDistanceEligibilityInputSection.prototype, 'initialize').and.callFake(_.noop);
            view = new CommunityCareNewAppointmentLayoutView({model: model});
            $view = view.$el;
            layout.showChildView('content', view);
        });

        afterEach(function() {
            layout.getRegion('content').empty();
        });
        describe('findClosestFacilityHelper', function() {
            it('should breakup an array of size > 25', function() {
                var ret = view.findClosestFacilityHelper();
                expect(ret).toEqual(splitLocations);
            });
        });
        it('has regions to show form sections', function () {
            expect(view.$el.has(view.regions.serviceSelectionSection).length).toEqual(1);
            expect(view.$el.has(view.regions.distanceSelectionLayout).length).toEqual(1);
            expect(view.$el.has(view.regions.ccDistanceEligibilityInputSection).length).toEqual(1);
        });
        describe('on show', function () {
            it('displays messages based on radio button answers', function () {
                expect(view.showCCDistanceEligibleMessage).toHaveBeenCalled();
                expect(view.disableContinueButton).toHaveBeenCalled();
            });
        });

        describe('when ADR is enabled', function() {
            it('bypass cc questions and enables the button', function() {
                view.handleADREnabled();
                expect(view.disableContinueButton).toHaveBeenCalled();
                expect(view.uncheckBothTravelRadios).toHaveBeenCalledWith(view.model);
                expect(view.enableContinueButton).toHaveBeenCalled();
            });
        });

        describe('when a link is clicked', function() {
            it('opens external link popup when a url link is clicked', function() {
                $view.find('.external-link').click();
                expect(view.openExternalLink).toHaveBeenCalled();
            });
        });


        describe('showing that you pass for community care', function () {
            it("it displays a message that you've fulfilled requirements for community care", function () {
                jasmine.createSpy('toggleTravelWithRadio').and.callFake(function(_view) {
                    expect(_view.showCCDistanceEligibleMessage).toHaveBeenCalled();
                });
            });

            it("it displays a message that you don't have the requirements for community care", function () {
                jasmine.createSpy('toggleUnusualWithRadio').and.callFake(function(_view) {
                    expect(_view.showCCDistanceEligibleMessage).toHaveBeenCalled();
                });
            });
        });
    });
}
);
